---
title: Custom fields · Cloudflare Logs docs
description: The HTTP requests dataset includes most standard log information by
  default. However, if you need to capture additional request or response
  headers or cookies, you can use custom fields to tailor the logs to your
  specific needs
lastUpdated: 2025-10-09T07:47:46.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/logs/logpush/logpush-job/custom-fields/
  md: https://developers.cloudflare.com/logs/logpush/logpush-job/custom-fields/index.md
---

The HTTP requests dataset includes most standard log information by default. However, if you need to capture additional request or response headers or cookies, you can use custom fields to tailor the logs to your specific needs

Custom fields are configured per zone and, once set up, are enabled for all Logpush jobs in that zone that use the HTTP requests dataset and include the request headers, response headers, or cookie fields. You can log these fields in their raw form or as transformed values.

By default:

* **Request headers** are logged as **raw values**.
* **Response headers** are logged as **transformed values**.

This default behavior can be changed. You can configure either request or response headers to be logged as raw or transformed, depending on your needs - but not both for the same header.

Custom fields can be enabled via API or the Cloudflare dashboard.

Note

Custom fields are only available for the [HTTP requests dataset](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/zone/http_requests/).

## Enable custom rules via API

Use the [Rulesets API](https://developers.cloudflare.com/ruleset-engine/rulesets-api/) to create a rule that configures custom fields. For more information on concepts like phases, rulesets, and rules, as well as the available API operations, refer to the [Ruleset Engine](https://developers.cloudflare.com/ruleset-engine/) documentation.

To configure custom fields:

1. Create a rule to configure the list of custom fields.
2. Include the `Cookies`, `RequestHeaders`, and/or `ResponseHeaders` fields in your Logpush job.

### 1. Create a rule to configure the list of custom fields

Create a rule configuring the list of custom fields in the `http_log_custom_fields` phase at the zone level. Set the rule action to `log_custom_field` and the rule expression to `true`.

The `action_parameters` object that you must include in the rule that configures the list of custom fields should have the following structure:

```json
"action_parameters": {
//select raw (default) or transformed request header
  "request_fields": [
    { "name": "<http_request_header_raw>" }
  ],
  "transformed_request_fields": [
    { "name": "<http_request_header_transformed>" }
  ],
//select raw or transformed (default) response header
  "response_fields": [
    { "name": "<http_response_header_transformed>" }
  ],
  "raw_response_fields": [
    { "name": "<http_response_header_raw>" }
  ],
  "cookie_fields": [
    { "name": "<cookie_name>" }
  ]
}
```

Ensure that your rule definition complies with the following:

* You must include at least one of the following arrays in the `action_parameters` object: `request_fields`, `transformed_request_fields`, `response_fields`, `raw_response_fields`, and `cookie_fields`.
* You must enter HTTP request and response header names in lower case.
* Cookie names are case sensitive — you must enter cookie names with the same capitalization they have in the HTTP request.
* You must set the rule expression to `true`.
* You can only log raw or transformed values for either request or response headers but not both for the same header.

Perform the following steps to create the rule:

1. Use the [List existing rulesets](https://developers.cloudflare.com/ruleset-engine/rulesets-api/view/#list-existing-rulesets) operation to check if there is already a ruleset for the `http_log_custom_fields` phase at the zone level (you can only have one zone ruleset per phase):

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets" \
  --request GET \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
```

If there is a ruleset for the `http_log_custom_fields` phase at the zone level, take note of the ruleset ID.

1. (Optional) If the response did not include a ruleset with `"kind": "zone"` and `"phase": "http_log_custom_fields"`, create the phase entry point ruleset using the [Create ruleset](https://developers.cloudflare.com/ruleset-engine/rulesets-api/create/) operation:

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets" \
  --request POST \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "name": "Zone-level phase entry point",
    "kind": "zone",
    "description": "This ruleset configures custom log fields.",
    "phase": "http_log_custom_fields"
  }'
```

Take note of the ruleset ID included in the response.

1. Use the [Update ruleset](https://developers.cloudflare.com/ruleset-engine/rulesets-api/update/) operation to define the rules of the entry point ruleset you found (or created in the previous step), adding a rule with the custom fields configuration. The rules you include in the request will replace all the rules in the ruleset.

   The following example configures custom fields with the names of the HTTP request headers, HTTP response headers, and cookies you wish to include in Logpush logs:

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets/$RULESET_ID" \
  --request PUT \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "rules": [
        {
            "action": "log_custom_field",
            "expression": "true",
            "description": "Set Logpush custom fields for HTTP requests",
            "action_parameters": {
                "request_fields": [
                    {
                        "name": "content-type"
                    },
                    {
                        "name": "x-forwarded-for"
                    }
                ],
                "transformed_request_fields": [
                    {
                        "name": "host"
                    }
                ],
                "response_fields": [
                    {
                        "name": "server"
                    },
                    {
                        "name": "content-type"
                    }
                ],
                "raw_response_fields": [
                    {
                        "name": "allow"
                    }
                ],
                "cookie_fields": [
                    {
                        "name": "__ga"
                    },
                    {
                        "name": "accountNumber"
                    },
                    {
                        "name": "__cfruid"
                    }
                ]
            }
        }
    ]
  }'
```

Example response:

```json
{
  "result": {
    "id": "<RULESET_ID>",
    "name": "Zone-level phase entry point",
    "description": "This ruleset configures custom log fields.",
    "kind": "zone",
    "version": "2",
    "rules": [
      {
        "id": "<RULE_ID_1>",
        "version": "1",
        "action": "log_custom_field",
        "action_parameters": {
          "request_fields": [
            { "name": "content-type" },
            { "name": "x-forwarded-for" },
        "transformed_request_fields": [
            { "name": "host" }
          ],
          "response_fields": [
            { "name": "server" },
            { "name": "content-type" },
        "raw_response_fields": [
            { "name": "allow" }
          ],
          "cookie_fields": [
            { "name": "__ga" },
            { "name": "accountNumber" },
            { "name": "__cfruid" }
          ]
        },
        "expression": "true",
        "description": "Set Logpush custom fields for HTTP requests",
        "last_updated": "2021-11-21T11:02:08.769537Z",
        "ref": "<RULE_REF_1>",
        "enabled": true
      }
    ],
    "last_updated": "2021-11-21T11:02:08.769537Z",
    "phase": "http_log_custom_fields"
  },
  "success": true,
  "errors": [],
  "messages": []
}
```

#### Record duplicate response header values

Some headers sent from the origin — such as `set-cookie` — may have multiple values that you want to capture. You can use the Rulesets API to specify which headers should have all their values logged.

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets/$RULESET_ID" \
  --request PUT \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "rules": [
        {
            "action": "log_custom_field",
            "expression": "true",
            "description": "Set Logpush custom fields for HTTP requests",
            "action_parameters": {
                "response_fields": [
                    {
                        "name": "set-cookie",
                        "preserve_duplicates": true
                    }
                ]
            }
        }
    ]
  }'
```

Note that `preserve_duplicates` applies to both `response_fields` and `raw_response_fields`. If there are no transform rules that affect a header, including `preserve_duplicates` in either `response_fields` or `raw_response_fields` should achieve the same result.

In this example, all values of the `set-cookie` headers will be logged. They will appear as an array of string values under `ResponseFields`, for example:

```json
{
…
“ResponseFields”: {
 “set-cookie”: [“name1=val1”, “name2=val2”...]
}
}
```

You can use a worker or custom logic at your logpush destination to extract these values.

### 2. Include the custom fields in your Logpush job

Next, include `Cookies`, `RequestHeaders`, `ResponseHeaders`, and/or `ResponseFields`, depending on your custom field configuration, in the list of fields of the `output_options` job parameter when creating or updating a job. The logs will contain the configured custom fields and their values in the request/response.

For example, consider the following request that creates a job that includes custom fields:

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Logs Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/logpush/jobs" \
  --request POST \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "name": "<DOMAIN_NAME>",
    "destination_conf": "s3://<BUCKET_PATH>?region=us-west-2",
    "dataset": "http_requests",
    "output_options": {
        "field_names": [
            "RayID",
            "EdgeStartTimestamp",
            "Cookies",
            "RequestHeaders",
            "ResponseHeaders"
        ],
        "timestamp_format": "rfc3339"
    },
    "ownership_challenge": "<OWNERSHIP_CHALLENGE_TOKEN>"
  }'
```

Note for Cloudflare Access users

If you are a Cloudflare Access user, as of March 2022 you have to manually add the `cf-access-user` user identity header to your logs by creating a custom fields ruleset or adding the `cf-access-user` HTTP request header to your custom fields configuration. Additionally, make sure that you include the `RequestHeaders` field in your Logpush job.

## Enable custom fields via dashboard

1. In the Cloudflare dashboard, go to the **Logpush** page.

   [Go to **Logpush**](https://dash.cloudflare.com/?to=/:account/:zone/analytics/logs)

2. In the **Custom log fields** section, select **Edit Custom Fields**.

3. Select **Set new Custom Field**.

4. From the **Field Type** dropdown, select *Request Header*, *Response Header* or *Cookies* and type the **Field Name**.

5. When you are done, select **Save**.

## Limitations

* Custom fields allow 100 headers per field type — this applies separately to `request_fields`, `transformed_request_fields`, `response_fields`, `raw_response_fields`, and `cookie_fields`.
* The request header `Range` is currently not supported by Custom Fields.
* Transformed and raw values for request and response headers are available only via the API and cannot be set through the UI.
