---
title: Error 407 · Cloudflare Support docs
description: >-
  The 407 Proxy Authentication Required status code indicates that the client
  did not provide the necessary authentication credentials to access the
  requested resource through a proxy server.

  For more details, refer to RFC 7235.
lastUpdated: 2025-05-21T17:09:12.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/4xx-client-error/error-407/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/4xx-client-error/error-407/index.md
---

## 407 Authentication Required

The `407 Proxy Authentication Required` status code indicates that the client did not provide the necessary authentication credentials to access the requested resource through a proxy server. For more details, refer to [RFC 7235](https://tools.ietf.org/html/rfc7235).

### Common use cases

This error typically occurs in environments where a proxy server is used as an intermediary between the client and the target server. To resolve this, the client must include the appropriate `Proxy-Authorization` header in the request with valid credentials.

### Cloudflare-specific information

Cloudflare does not generate `407` errors but proxies them from the origin server or an upstream proxy. If a `407` error occurs on a Cloudflare-powered site, review the origin server's proxy configuration to ensure authentication requirements are properly set, and verify that the client is providing the required credentials.
